/*
 * Decompiled with CFR 0.152.
 */
package juegos;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.PauseTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.SequentialTransition;
import javafx.animation.TranslateTransition;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.AudioClip;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;
import juegos.ControlledScreen;
import juegos.Funciones;
import juegos.Juegos;
import juegos.ScreensController;

public class MemoriaController
implements Initializable,
ControlledScreen {
    private ScreensController myController;
    private static ImageView actImg;
    private static String nameImg;
    private static String idImg;
    private static boolean nota;
    private static int nivel;
    private static int moves;
    private static int contMoves;
    private static int parejas;
    private static int total_parejas;
    private static int minutos;
    private static int segundo;
    private static AudioClip actNota;
    private static AudioClip audioTemp;
    private static ArrayList<ImageView> cartasSeleccionadas;
    private static final ArrayList<Thread> listaThreads;
    private static Reloj reloj;
    private final Duration duracion = Duration.seconds((double)1.0);
    private ArrayList<Button> botonesPractica;
    private static final String[] musicos;
    private static final String[] piezas;
    private static final String[] piezas2;
    private static final String[] piezas3;
    @FXML
    AnchorPane main;
    @FXML
    AnchorPane pantalla1;
    @FXML
    AnchorPane pantalla2;
    @FXML
    AnchorPane pantallaJuego;
    @FXML
    AnchorPane pantallaFinal;
    @FXML
    AnchorPane img_ganador;
    @FXML
    ImageView tituloPantalla1;
    @FXML
    ImageView presentaPantalla1;
    @FXML
    ImageView subtituloPantalla1;
    @FXML
    ImageView telon;
    @FXML
    ImageView fondoJuego;
    @FXML
    ImageView tituloPantalla2;
    @FXML
    ImageView img_resultado;
    @FXML
    ImageView resultadoIMG;
    @FXML
    Button continuarPantalla1;
    @FXML
    Button continuarPantalla2;
    @FXML
    Button btn_repetir;
    @FXML
    Button btn_repetirTodo;
    @FXML
    Button continuar_resultado;
    @FXML
    VBox cajaVertical;
    @FXML
    Label empezamosen;
    @FXML
    Label countLabel;
    @FXML
    ProgressBar barraTiempo;
    @FXML
    Button pra1;
    @FXML
    Button pra2;
    @FXML
    Button pra3;
    @FXML
    Button pra4;
    @FXML
    Button pra5;
    @FXML
    Button pra6;
    @FXML
    Button pra7;
    @FXML
    Button pra8;
    @FXML
    Button pra9;
    @FXML
    Button pra10;
    @FXML
    Button pra11;
    @FXML
    Button pra12;
    @FXML
    Button pra13;
    @FXML
    Button pra14;
    @FXML
    Button pra15;

    @FXML
    private void Salir_Juego(ActionEvent event) {
        Funciones.juego_on = false;
        Funciones.audio.play();
        this.myController.setScreen(Juegos.menuID);
    }

    @FXML
    private void ReiniciarTodo(ActionEvent event) {
        nivel = 1;
        this.ocultarPantallaFinal();
    }

    @FXML
    private void ReiniciarNivel(ActionEvent event) {
        this.ocultarJuegoGanado();
        if (actNota != null && actNota.isPlaying()) {
            actNota.stop();
        }
        for (Thread t : listaThreads) {
            t.interrupt();
        }
        listaThreads.clear();
        if (reloj != null) {
            reloj.stop();
        }
        cartasSeleccionadas = new ArrayList();
        this.nivelFacil();
    }

    @FXML
    private void siguienteNivel(ActionEvent event) {
        this.ocultarJuegoGanado();
        TranslateTransition tran = this.abrirTelon();
        tran.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (nivel == 3) {
                    MemoriaController.this.mostrarPantallaFinal();
                } else {
                    nivel++;
                    MemoriaController.this.nivelFacil();
                }
            }
        });
        SequentialTransition seq = new SequentialTransition(new Animation[]{tran, this.cerrarTelon()});
        seq.play();
    }

    public void initialize(URL url, ResourceBundle rb) {
        nivel = 1;
        this.empezamosen.setVisible(false);
        this.countLabel.setVisible(false);
        this.img_resultado.setVisible(false);
        this.initBotonesPractica();
        this.cancionPrincipal();
        this.mostrarPrimerPantalla();
    }

    private void cancionPrincipal() {
        actNota = new AudioClip(this.getClass().getResource("Sonidos/memoriaSounds/TEMA DEL JUEGO - ALLEGRO ASSAI BRANDEMBURGO.mp3").toString());
        actNota.setCycleCount(-1);
        Thread sonando = new Thread(){

            @Override
            public void run() {
                actNota.play();
                boolean band = true;
                while (band) {
                    if (!Funciones.juego_on) {
                        actNota.stop();
                    }
                    if (actNota.isPlaying()) continue;
                    band = false;
                }
            }
        };
        listaThreads.add(sonando);
        sonando.start();
    }

    private void pararCancionPrincipal() {
        if (actNota != null && actNota.isPlaying()) {
            actNota.stop();
        }
    }

    private void initBotonesPractica() {
        this.botonesPractica = new ArrayList();
        this.botonesPractica.add(this.pra1);
        this.botonesPractica.add(this.pra2);
        this.botonesPractica.add(this.pra3);
        this.botonesPractica.add(this.pra4);
        this.botonesPractica.add(this.pra5);
        this.botonesPractica.add(this.pra6);
        this.botonesPractica.add(this.pra7);
        this.botonesPractica.add(this.pra8);
        this.botonesPractica.add(this.pra9);
        this.botonesPractica.add(this.pra10);
        this.botonesPractica.add(this.pra11);
        this.botonesPractica.add(this.pra12);
        this.botonesPractica.add(this.pra13);
        this.botonesPractica.add(this.pra14);
        this.botonesPractica.add(this.pra15);
        for (int i = 0; i < this.botonesPractica.size(); ++i) {
            Button b = this.botonesPractica.get(i);
            b.setId(i + "");
            b.setCursor(Cursor.HAND);
            b.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    Button b = (Button)event.getSource();
                    int id = Integer.parseInt(b.getId());
                    String cancion = "";
                    switch (id) {
                        case 0: {
                            cancion = "NIVEL1/MINUETO EN SOL - BACH.mp3";
                            break;
                        }
                        case 1: {
                            cancion = "NIVEL2/BRANDEMBURGO 5 - BACH.mp3";
                            break;
                        }
                        case 2: {
                            cancion = "NIVEL3/TOCCATA Y FUGA - BACH.mp3";
                            break;
                        }
                        case 3: {
                            cancion = "NIVEL1/HIMNO A LA ALEGRIA - SINFONICO - BEETHOVEN.mp3";
                            break;
                        }
                        case 4: {
                            cancion = "NIVEL2/PARA ELISA - BEETHOVEN.mp3";
                            break;
                        }
                        case 5: {
                            cancion = "NIVEL3/5a SINFONA - BEETHOVEN.mp3";
                            break;
                        }
                        case 6: {
                            cancion = "NIVEL1/SINFONIA DE LOS JUGUETES - HAYDN.mp3";
                            break;
                        }
                        case 7: {
                            cancion = "NIVEL2/SINFONIA DEL RELOJ - HAYDN.mp3";
                            break;
                        }
                        case 8: {
                            cancion = "NIVEL3/Haydn _ Symphony No 94.mp3";
                            break;
                        }
                        case 9: {
                            cancion = "NIVEL1/HIMNO NACIONAL - ALVAREZ OVALLE.mp3";
                            break;
                        }
                        case 10: {
                            cancion = "NIVEL2/BOLERO PARA GUITARRA - ALVAREZ OVALLE.mp3";
                            break;
                        }
                        case 11: {
                            cancion = "NIVEL3/ESTRELLA DE GUATEMALA - ALVAREZ OVALLE.mp3";
                            break;
                        }
                        case 12: {
                            cancion = "NIVEL1/ESTRELLITA VARIACIONES EN DO - MOZART.mp3";
                            break;
                        }
                        case 13: {
                            cancion = "NIVEL2/PEQUENA SERENATA NOCTURNA - MOZART.mp3";
                            break;
                        }
                        case 14: {
                            cancion = "NIVEL3/SINFONIA 40 - MOZART.mp3";
                        }
                    }
                    if (actNota != null && actNota.isPlaying()) {
                        actNota.stop();
                    }
                    System.out.println(cancion);
                    actNota = new AudioClip(this.getClass().getResource("Sonidos/memoriaSounds/" + cancion).toString());
                    Thread sonando = new Thread(){

                        @Override
                        public void run() {
                            actNota.play();
                            boolean band = true;
                            while (band) {
                                if (!Funciones.juego_on) {
                                    actNota.stop();
                                }
                                if (actNota.isPlaying()) continue;
                                band = false;
                            }
                        }
                    };
                    listaThreads.add(sonando);
                    sonando.start();
                }
            });
        }
    }

    private void acomodarFullScreen(AnchorPane m) {
        if (System.getProperty("os.name").startsWith("Windows")) {
            Rectangle screenSize = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
            System.out.println(screenSize.width + " , " + screenSize.height);
            double posScreenX = (double)(screenSize.width / 2) - this.main.getPrefWidth() / 2.0;
            double posScreenY = (double)(screenSize.height / 2) - this.main.getPrefHeight() / 2.0;
            float w = (float)screenSize.width / (float)this.main.getPrefWidth();
            float h = (float)screenSize.height / (float)this.main.getPrefHeight();
            m.setLayoutX(posScreenX);
            m.setLayoutY(posScreenY);
            m.setScaleX((double)w);
            m.setScaleY((double)h);
            System.out.println(posScreenX + " , " + posScreenY + " , " + w + " , " + h);
        }
    }

    private void mostrarPrimerPantalla() {
        this.pantalla1.setLayoutX(0.0);
        this.continuarPantalla1.setOpacity(0.0);
        this.continuarPantalla1.setCursor(Cursor.HAND);
        this.continuarPantalla1.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.ocultarPrimerPantalla();
            }
        });
        TranslateTransition tran1 = new TranslateTransition(this.duracion, (Node)this.presentaPantalla1);
        tran1.setFromY(this.presentaPantalla1.getLayoutY());
        tran1.setToY(-this.presentaPantalla1.getLayoutY() + 30.0);
        TranslateTransition tran2 = new TranslateTransition(this.duracion, (Node)this.tituloPantalla1);
        tran2.setFromY(this.tituloPantalla1.getLayoutY());
        tran2.setToY(-this.tituloPantalla1.getLayoutY() + 140.0);
        TranslateTransition tran3 = new TranslateTransition(this.duracion, (Node)this.subtituloPantalla1);
        tran3.setFromY(this.subtituloPantalla1.getLayoutY());
        tran3.setToY(-this.subtituloPantalla1.getLayoutY() + 210.0);
        FadeTransition fade = new FadeTransition(this.duracion, (Node)this.continuarPantalla1);
        fade.setFromValue(0.0);
        fade.setToValue(1.0);
        RotateTransition rotate = new RotateTransition(this.duracion, (Node)this.continuarPantalla1);
        rotate.setFromAngle(-5.0);
        rotate.setToAngle(5.0);
        rotate.setCycleCount(-1);
        rotate.setAutoReverse(true);
        SequentialTransition seq = new SequentialTransition(new Animation[]{new PauseTransition(this.duracion), tran1, new PauseTransition(this.duracion), tran2, new PauseTransition(this.duracion), tran3, new PauseTransition(this.duracion), fade, rotate});
        seq.play();
    }

    private void ocultarPrimerPantalla() {
        TranslateTransition tran = this.abrirTelon();
        tran.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.pantalla1.setVisible(false);
                MemoriaController.this.mostrarSegundaPantalla();
            }
        });
        SequentialTransition seq = new SequentialTransition(new Animation[]{tran, this.cerrarTelon()});
        seq.play();
    }

    private void mostrarSegundaPantalla() {
        this.pantalla2.setLayoutX(0.0);
        this.tituloPantalla2.setOpacity(0.0);
        this.continuarPantalla2.setOpacity(0.0);
        this.continuarPantalla2.setCursor(Cursor.HAND);
        this.continuarPantalla2.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.ocultarSegundaPantalla();
            }
        });
        FadeTransition fade1 = new FadeTransition(this.duracion, (Node)this.tituloPantalla2);
        fade1.setFromValue(0.0);
        fade1.setToValue(1.0);
        FadeTransition fade2 = new FadeTransition(this.duracion, (Node)this.continuarPantalla2);
        fade2.setFromValue(0.0);
        fade2.setToValue(1.0);
        RotateTransition rot = new RotateTransition(this.duracion, (Node)this.continuarPantalla2);
        rot.setFromAngle(-5.0);
        rot.setToAngle(5.0);
        rot.setCycleCount(-1);
        rot.setAutoReverse(true);
        SequentialTransition seq = new SequentialTransition(new Animation[]{new PauseTransition(this.duracion), fade1, fade2, rot});
        seq.play();
    }

    private void ocultarSegundaPantalla() {
        TranslateTransition tran = this.abrirTelon();
        tran.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.pantalla2.setVisible(false);
                MemoriaController.this.mostrarPantallaJuego();
            }
        });
        SequentialTransition seq = new SequentialTransition(new Animation[]{tran, this.cerrarTelon()});
        seq.play();
    }

    private void mostrarPantallaFinal() {
        this.cancionPrincipal();
        this.pantallaJuego.setVisible(false);
        this.pantallaFinal.setLayoutX(0.0);
        this.pantallaFinal.setVisible(true);
    }

    private void ocultarPantallaFinal() {
        this.pantallaFinal.setVisible(false);
        this.pantallaJuego.setVisible(true);
        this.mostrarPantallaJuego();
    }

    private void mostrarPantallaJuego() {
        this.pantallaJuego.setLayoutX(0.0);
        this.pararCancionPrincipal();
        this.nivelFacil();
    }

    private void nivelFacil() {
        int i;
        if (audioTemp != null && audioTemp.isPlaying()) {
            audioTemp.stop();
        }
        int total = 10;
        total_parejas = 5;
        switch (nivel) {
            case 1: {
                minutos = 1;
                segundo = 40;
                break;
            }
            case 2: {
                minutos = 1;
                segundo = 20;
                break;
            }
            case 3: {
                minutos = 1;
                segundo = 0;
            }
        }
        moves = 2;
        contMoves = 0;
        parejas = 0;
        cartasSeleccionadas = new ArrayList();
        if (this.fondoJuego.getStyleClass().size() > 0) {
            this.fondoJuego.getStyleClass().remove(0);
        }
        String imgForCards = "";
        switch (nivel) {
            case 1: {
                this.fondoJuego.getStyleClass().add((Object)"fondoNivelFacil");
                imgForCards = "Carta_N1.png";
                break;
            }
            case 2: {
                this.fondoJuego.getStyleClass().add((Object)"fondoNivelMedio");
                imgForCards = "Carta_N2.png";
                break;
            }
            case 3: {
                this.fondoJuego.getStyleClass().add((Object)"fondoNivelDificil");
                imgForCards = "Carta_N3.png";
            }
        }
        ArrayList musicos_pos = new ArrayList();
        ArrayList cancion_pos = new ArrayList();
        for (int i2 = 0; i2 < 5; ++i2) {
            this.norepetirnumerosaleatorios(5, musicos_pos);
            this.norepetirnumerosaleatorios(5, cancion_pos);
        }
        ArrayList<Integer> pos = new ArrayList<Integer>();
        Iterator iterator = musicos_pos.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            pos.add(i);
        }
        iterator = cancion_pos.iterator();
        while (iterator.hasNext()) {
            i = (Integer)iterator.next();
            pos.add(i + 5);
        }
        this.cajaVertical.getChildren().clear();
        HBox h1 = new HBox();
        HBox h2 = new HBox();
        h1.setPrefHeight(this.cajaVertical.getPrefHeight() / 2.0);
        h2.setPrefHeight(this.cajaVertical.getPrefHeight() / 2.0);
        h1.setPrefWidth(this.cajaVertical.getPrefWidth());
        h2.setPrefWidth(this.cajaVertical.getPrefWidth());
        for (int i3 = 0; i3 < total; ++i3) {
            ImageView img = new ImageView(new Image(this.getClass().getResource("Imagenes/memoriaImages/" + imgForCards).toString()));
            img.setId(pos.get(i3) + "");
            img.setPreserveRatio(false);
            img.setFitWidth(this.cajaVertical.getPrefWidth() / 5.0);
            img.setFitHeight(this.cajaVertical.getPrefHeight() / 2.0);
            img.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent t) {
                    MemoriaController.this.voltearCarta((ImageView)t.getSource());
                }
            });
            if (i3 < 5) {
                h1.getChildren().add((Object)img);
                continue;
            }
            h2.getChildren().add((Object)img);
        }
        this.cajaVertical.getChildren().add((Object)h1);
        this.cajaVertical.getChildren().add((Object)h2);
        this.cuentaRegresiva();
    }

    private void voltearCarta(ImageView img) {
        actImg = img;
        actImg.setDisable(true);
        int pos = Integer.parseInt(actImg.getId());
        cartasSeleccionadas.add(img);
        System.out.println(pos);
        if (pos <= 5) {
            nameImg = musicos[pos - 1];
            nota = false;
        } else {
            nameImg = "Carta_Nota.png";
            nota = true;
        }
        this.flip_sound();
        RotateTransition rot = this.Rotar((Node)img);
        rot.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.compararCartas();
                if (nota) {
                    System.out.println("Musica");
                    int pos1 = Integer.parseInt(actImg.getId());
                    if (!"".equals(piezas[pos1 -= 6])) {
                        if (actNota != null && actNota.isPlaying()) {
                            actNota.stop();
                        }
                        String track = "";
                        switch (nivel) {
                            case 1: {
                                track = "NIVEL1/" + piezas[pos1];
                                break;
                            }
                            case 2: {
                                track = "NIVEL2/" + piezas2[pos1];
                                break;
                            }
                            case 3: {
                                track = "NIVEL3/" + piezas3[pos1];
                            }
                        }
                        actNota = new AudioClip(this.getClass().getResource("Sonidos/memoriaSounds/" + track).toString());
                        Thread sonando = new Thread(){

                            @Override
                            public void run() {
                                actNota.play();
                                boolean band = true;
                                while (band) {
                                    if (!Funciones.juego_on) {
                                        actNota.stop();
                                    }
                                    if (actNota.isPlaying()) continue;
                                    band = false;
                                }
                            }
                        };
                        listaThreads.add(sonando);
                        sonando.start();
                    }
                }
            }
        });
        rot.play();
        actImg.setImage(new Image(this.getClass().getResource("Imagenes/memoriaImages/" + nameImg).toString()));
    }

    private void compararCartas() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MemoriaController.this.btn_repetir.setDisable(true);
                contMoves++;
                if (contMoves == moves) {
                    MemoriaController.this.cajaVertical.setDisable(true);
                    MemoriaController.this.parejaNivelFacil();
                    MemoriaController.this.cajaVertical.setDisable(false);
                    contMoves = 0;
                    listaThreads.clear();
                }
                MemoriaController.this.btn_repetir.setDisable(false);
            }
        });
    }

    private void parejaNivelFacil() {
        int carta1 = Integer.parseInt(cartasSeleccionadas.get(0).getId());
        int carta2 = Integer.parseInt(cartasSeleccionadas.get(1).getId());
        System.out.println(carta1 + " " + carta2);
        if (carta1 == carta2 - 5 || carta2 == carta1 - 5) {
            this.acierto(true);
            System.out.println("Pareja");
            for (int i = 0; i <= 1; ++i) {
                cartasSeleccionadas.get(i).setDisable(true);
            }
            cartasSeleccionadas = new ArrayList();
            try {
                Thread.sleep(1500L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MemoriaController.class.getName()).log(Level.SEVERE, null, ex);
            }
            actNota.stop();
            if (++parejas == total_parejas) {
                this.juegoGanado();
            }
        } else {
            this.acierto(false);
            try {
                Thread.sleep(1500L);
                if (actNota != null && actNota.isPlaying()) {
                    actNota.stop();
                }
                for (int i = 0; i <= 1; ++i) {
                    cartasSeleccionadas.get(i).setDisable(false);
                }
                RotateTransition rot1 = this.Rotar_regreso((Node)cartasSeleccionadas.get(0));
                RotateTransition rot2 = this.Rotar_regreso((Node)cartasSeleccionadas.get(1));
                rot1.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        String imgForCard = "";
                        switch (nivel) {
                            case 1: {
                                imgForCard = "Carta_N1.png";
                                break;
                            }
                            case 2: {
                                imgForCard = "Carta_N2.png";
                                break;
                            }
                            case 3: {
                                imgForCard = "Carta_N3.png";
                            }
                        }
                        for (int i = 0; i <= 1; ++i) {
                            ((ImageView)cartasSeleccionadas.get(i)).setImage(new Image(this.getClass().getResource("Imagenes/memoriaImages/" + imgForCard).toString()));
                        }
                        cartasSeleccionadas = new ArrayList();
                    }
                });
                rot1.play();
                rot2.play();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(MemoriaController.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private TranslateTransition abrirTelon() {
        TranslateTransition tran = new TranslateTransition(this.duracion, (Node)this.telon);
        tran.setFromY(this.telon.getLayoutY());
        tran.setToY(-this.telon.getLayoutY());
        return tran;
    }

    private TranslateTransition cerrarTelon() {
        TranslateTransition tran = new TranslateTransition(this.duracion, (Node)this.telon);
        tran.setFromY(-this.telon.getLayoutY());
        tran.setToY(this.telon.getLayoutY());
        return tran;
    }

    private void flip_sound() {
        AudioClip clip = new AudioClip(this.getClass().getResource("Sonidos/memoriaSounds/flip.wav").toString());
        clip.play();
    }

    private void acierto(boolean band) {
        final boolean b = band;
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                MemoriaController.this.img_resultado.getStyleClass().clear();
                if (!b) {
                    MemoriaController.this.img_resultado.getStyleClass().add((Object)"img_error");
                } else {
                    MemoriaController.this.img_resultado.getStyleClass().add((Object)"img_correcto");
                }
                MemoriaController.this.img_resultado.setVisible(true);
                FadeTransition fade = new FadeTransition(Duration.seconds((double)1.0), (Node)MemoriaController.this.img_resultado);
                fade.setFromValue(1.0);
                fade.setToValue(0.0);
                fade.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

                    public void handle(ActionEvent event) {
                        MemoriaController.this.img_resultado.setVisible(false);
                    }
                });
                fade.play();
            }
        });
    }

    private void juegoGanado() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                audioTemp = new AudioClip(this.getClass().getResource("Sonidos/sonidoTikal/Aplauso.wav").toString());
                audioTemp.play();
                reloj.stop();
                reloj = null;
                GaussianBlur gaussianBlur = new GaussianBlur();
                gaussianBlur.setRadius(8.0);
                MemoriaController.this.pantallaJuego.setEffect((Effect)gaussianBlur);
                MemoriaController.this.pantallaJuego.setDisable(true);
                MemoriaController.this.img_ganador.setLayoutX(MemoriaController.this.pantallaJuego.getPrefWidth() / 2.0 - MemoriaController.this.img_ganador.getPrefWidth() / 2.0);
                MemoriaController.this.resultadoIMG.getStyleClass().remove(0);
                MemoriaController.this.resultadoIMG.getStyleClass().add((Object)"img_ganador");
                MemoriaController.this.continuar_resultado.setVisible(true);
            }
        });
    }

    private void juegoPerdido() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                GaussianBlur gaussianBlur = new GaussianBlur();
                gaussianBlur.setRadius(8.0);
                MemoriaController.this.pantallaJuego.setEffect((Effect)gaussianBlur);
                MemoriaController.this.pantallaJuego.setDisable(true);
                MemoriaController.this.img_ganador.setLayoutX(MemoriaController.this.pantallaJuego.getPrefWidth() / 2.0 - MemoriaController.this.img_ganador.getPrefWidth() / 2.0);
                MemoriaController.this.resultadoIMG.getStyleClass().remove(0);
                MemoriaController.this.resultadoIMG.getStyleClass().add((Object)"img_perdedor");
                MemoriaController.this.continuar_resultado.setVisible(false);
            }
        });
    }

    private void ocultarJuegoGanado() {
        this.img_ganador.setLayoutX(-900.0);
        this.pantallaJuego.setEffect(null);
        this.pantallaJuego.setDisable(false);
    }

    private RotateTransition Rotar(Node card) {
        RotateTransition rotator = new RotateTransition(Duration.millis((double)150.0), card);
        rotator.setAxis(Rotate.Y_AXIS);
        rotator.setFromAngle(0.0);
        rotator.setToAngle(180.0);
        rotator.setInterpolator(Interpolator.LINEAR);
        rotator.setCycleCount(1);
        return rotator;
    }

    private RotateTransition Rotar_regreso(Node card) {
        RotateTransition rotator = new RotateTransition(Duration.millis((double)250.0), card);
        rotator.setAxis(Rotate.Y_AXIS);
        rotator.setFromAngle(180.0);
        rotator.setToAngle(0.0);
        rotator.setInterpolator(Interpolator.LINEAR);
        rotator.setCycleCount(1);
        return rotator;
    }

    public void norepetirnumerosaleatorios(int total, ArrayList array) {
        Random rand = new Random();
        Integer n = rand.nextInt(total - 1 + 1) + 1;
        if (array.contains(n)) {
            this.norepetirnumerosaleatorios(total, array);
        } else {
            array.add(n);
        }
    }

    private void cuentaRegresiva() {
        this.pantallaJuego.setDisable(true);
        this.countLabel.setVisible(true);
        this.countLabel.setScaleX(5.0);
        this.countLabel.setScaleY(5.0);
        this.empezamosen.setVisible(true);
        this.countLabel.setText("3");
        ScaleTransition fade3 = this.fadeCount();
        ScaleTransition fade2 = this.fadeCount();
        ScaleTransition fade1 = this.fadeCount();
        fade3.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.countLabel.setText("2");
            }
        });
        fade2.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.countLabel.setText("1");
            }
        });
        fade1.setOnFinished((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                MemoriaController.this.countLabel.setVisible(false);
                MemoriaController.this.pantallaJuego.setDisable(false);
                MemoriaController.this.empezamosen.setVisible(false);
                reloj = new Reloj(minutos, segundo);
                reloj.start();
            }
        });
        SequentialTransition seq = new SequentialTransition(new Animation[]{fade3, fade2, fade1});
        seq.play();
    }

    private ScaleTransition fadeCount() {
        ScaleTransition scale = new ScaleTransition(this.duracion, (Node)this.countLabel);
        scale.setFromX(5.0);
        scale.setFromY(5.0);
        scale.setToX(0.0);
        scale.setToY(0.0);
        return scale;
    }

    @Override
    public void setScreenParent(ScreensController screenPage) {
        this.myController = screenPage;
    }

    static {
        nota = false;
        nivel = 1;
        moves = 2;
        contMoves = 0;
        parejas = 0;
        minutos = 0;
        segundo = 0;
        listaThreads = new ArrayList();
        musicos = new String[]{"Carta_BACH.png", "Carta_BEETHOVEN.png", "Carta_HAYDN.png", "Carta_MOZART.png", "Carta_OVALLE.png"};
        piezas = new String[]{"MINUETO EN SOL - BACH.mp3", "HIMNO A LA ALEGRIA - SINFONICO - BEETHOVEN.mp3", "SINFONIA DE LOS JUGUETES - HAYDN.mp3", "ESTRELLITA VARIACIONES EN DO - MOZART.mp3", "HIMNO NACIONAL - ALVAREZ OVALLE.mp3"};
        piezas2 = new String[]{"BRANDEMBURGO 5 - BACH.mp3", "PARA ELISA - BEETHOVEN.mp3", "SINFONIA DEL RELOJ - HAYDN.mp3", "PEQUENA SERENATA NOCTURNA - MOZART.mp3", "BOLERO PARA GUITARRA - ALVAREZ OVALLE.mp3"};
        piezas3 = new String[]{"TOCCATA Y FUGA - BACH.mp3", "5a SINFONA - BEETHOVEN.mp3", "Haydn _ Symphony No 94.mp3", "SINFONIA 40 - MOZART.mp3", "ESTRELLA DE GUATEMALA - ALVAREZ OVALLE.mp3"};
    }

    public class Reloj
    extends Thread {
        private int min;
        private int sec;
        private int j;
        private int totalsec;
        private int recSec;

        public Reloj(int m, int s) {
            this.min = m;
            this.sec = s;
            this.recSec = this.totalsec = m * 60 + s;
        }

        @Override
        public void run() {
            for (int i = this.min; i >= 0; --i) {
                this.j = this.sec;
                while (this.j >= 0 && Funciones.juego_on) {
                    this.min = i;
                    this.sec = this.j;
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            String s = ":";
                            if (Reloj.this.sec < 10) {
                                s = s + "0";
                            }
                            double d = (double)Reloj.this.recSec / (double)Reloj.this.totalsec;
                            MemoriaController.this.barraTiempo.setProgress(d);
                            if (d >= 0.6) {
                                if (!"green-bar".equals(MemoriaController.this.barraTiempo.getStyleClass().get(1))) {
                                    MemoriaController.this.barraTiempo.getStyleClass().remove(1);
                                    MemoriaController.this.barraTiempo.getStyleClass().add((Object)"green-bar");
                                }
                            } else if (d < 0.6 && d >= 0.4) {
                                if (!"yellow-bar".equals(MemoriaController.this.barraTiempo.getStyleClass().get(1))) {
                                    MemoriaController.this.barraTiempo.getStyleClass().remove(1);
                                    MemoriaController.this.barraTiempo.getStyleClass().add((Object)"yellow-bar");
                                }
                            } else if (d < 0.4 && d >= 0.2) {
                                if (!"orange-bar".equals(MemoriaController.this.barraTiempo.getStyleClass().get(1))) {
                                    MemoriaController.this.barraTiempo.getStyleClass().remove(1);
                                    MemoriaController.this.barraTiempo.getStyleClass().add((Object)"orange-bar");
                                }
                            } else if (d < 0.2 && !"red-bar".equals(MemoriaController.this.barraTiempo.getStyleClass().get(1))) {
                                MemoriaController.this.barraTiempo.getStyleClass().remove(1);
                                MemoriaController.this.barraTiempo.getStyleClass().add((Object)"red-bar");
                            }
                            if (Reloj.this.j == 0) {
                                Reloj.this.sec = 59;
                            }
                        }
                    });
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(MemoriaController.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    --this.recSec;
                    --this.j;
                }
            }
            MemoriaController.this.juegoPerdido();
        }
    }
}

